/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.LineNumber;

public final class LineNumberTable
extends Attribute {
    private boolean isInPackedState = false;
    private byte[] data;
    private int line_number_table_length;
    private LineNumber[] line_number_table;

    public LineNumberTable(LineNumberTable c) {
        this(c.getNameIndex(), c.getLength(), c.getLineNumberTable(), c.getConstantPool());
    }

    public LineNumberTable(int name_index, int length, LineNumber[] line_number_table, ConstantPool constant_pool) {
        super((byte)4, name_index, length, constant_pool);
        this.setLineNumberTable(line_number_table);
        this.isInPackedState = false;
    }

    LineNumberTable(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (LineNumber[])null, constant_pool);
        this.data = new byte[length];
        int byteReads = file.read(this.data);
        this.isInPackedState = true;
    }

    private void unpack() {
        if (!this.isInPackedState) {
            return;
        }
        try {
            ByteArrayInputStream bs = new ByteArrayInputStream(this.data);
            DataInputStream dis = new DataInputStream(bs);
            this.line_number_table_length = dis.readUnsignedShort();
            this.line_number_table = new LineNumber[this.line_number_table_length];
            int i = 0;
            while (i < this.line_number_table_length) {
                this.line_number_table[i] = new LineNumber(dis);
                ++i;
            }
            dis.close();
            this.data = null;
        }
        catch (IOException e) {
            throw new RuntimeException("Unpacking of LineNumberTable attribute failed");
        }
        this.isInPackedState = false;
    }

    public void accept(ClassVisitor v) {
        this.unpack();
        v.visitLineNumberTable(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        if (this.isInPackedState) {
            file.write(this.data);
        } else {
            file.writeShort(this.line_number_table_length);
            int i = 0;
            while (i < this.line_number_table_length) {
                this.line_number_table[i].dump(file);
                ++i;
            }
        }
    }

    public final LineNumber[] getLineNumberTable() {
        this.unpack();
        return this.line_number_table;
    }

    public final void setLineNumberTable(LineNumber[] line_number_table) {
        this.data = null;
        this.isInPackedState = false;
        this.line_number_table = line_number_table;
        this.line_number_table_length = line_number_table == null ? 0 : line_number_table.length;
    }

    public final String toString() {
        this.unpack();
        StringBuffer buf = new StringBuffer();
        StringBuffer line = new StringBuffer();
        int i = 0;
        while (i < this.line_number_table_length) {
            line.append(this.line_number_table[i].toString());
            if (i < this.line_number_table_length - 1) {
                line.append(", ");
            }
            if (line.length() > 72) {
                line.append('\n');
                buf.append(line);
                line.setLength(0);
            }
            ++i;
        }
        buf.append(line);
        return buf.toString();
    }

    public int getSourceLine(int pos) {
        this.unpack();
        int l = 0;
        int r = this.line_number_table_length - 1;
        if (r < 0) {
            return -1;
        }
        int min_index = -1;
        int min = -1;
        do {
            int i;
            int j;
            if ((j = this.line_number_table[i = (l + r) / 2].getStartPC()) == pos) {
                return this.line_number_table[i].getLineNumber();
            }
            if (pos < j) {
                r = i - 1;
            } else {
                l = i + 1;
            }
            if (j >= pos || j <= min) continue;
            min = j;
            min_index = i;
        } while (l <= r);
        if (min_index < 0) {
            return -1;
        }
        return this.line_number_table[min_index].getLineNumber();
    }

    public Attribute copy(ConstantPool constant_pool) {
        this.unpack();
        LineNumberTable c = (LineNumberTable)this.clone();
        c.line_number_table = new LineNumber[this.line_number_table_length];
        int i = 0;
        while (i < this.line_number_table_length) {
            c.line_number_table[i] = this.line_number_table[i].copy();
            ++i;
        }
        c.constantPool = constant_pool;
        return c;
    }

    public final int getTableLength() {
        this.unpack();
        return this.line_number_table_length;
    }
}

