/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps.dsc;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSResource;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentDocumentNeededResources;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentDocumentSuppliedResources;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentPageResources;

public class ResourceTracker {
    private Set documentSuppliedResources;
    private Set documentNeededResources;
    private Set usedResources;
    private Set pageResources;

    public Set getDocumentSuppliedResources() {
        if (this.documentSuppliedResources != null) {
            return Collections.unmodifiableSet(this.documentSuppliedResources);
        }
        return Collections.EMPTY_SET;
    }

    public Set getDocumentNeededResources() {
        if (this.documentNeededResources != null) {
            return Collections.unmodifiableSet(this.documentNeededResources);
        }
        return Collections.EMPTY_SET;
    }

    public void notifyStartNewPage() {
        if (this.pageResources != null) {
            this.pageResources.clear();
        }
    }

    public void registerSuppliedResource(PSResource res) {
        if (this.documentSuppliedResources == null) {
            this.documentSuppliedResources = new HashSet();
        }
        this.documentSuppliedResources.add(res);
        if (this.documentNeededResources != null) {
            this.documentNeededResources.remove(res);
        }
    }

    public void registerNeededResource(PSResource res) {
        if (this.documentNeededResources == null) {
            this.documentNeededResources = new HashSet();
        }
        if (!this.documentSuppliedResources.contains(res)) {
            this.documentNeededResources.add(res);
        }
    }

    public void notifyResourceUsageOnPage(PSResource res) {
        if (this.pageResources == null) {
            this.pageResources = new HashSet();
        }
        this.pageResources.add(res);
    }

    public void notifyResourceUsageOnPage(Collection resources) {
        if (this.pageResources == null) {
            this.pageResources = new HashSet();
        }
        this.pageResources.addAll(resources);
    }

    public boolean isResourceSupplied(PSResource res) {
        return this.documentSuppliedResources != null && this.documentSuppliedResources.contains(res);
    }

    public void writeResources(boolean pageLevel, PSGenerator gen) throws IOException {
        if (pageLevel) {
            new DSCCommentPageResources(this.pageResources).generate(gen);
            if (this.usedResources == null) {
                this.usedResources = new HashSet();
            }
            this.usedResources.addAll(this.pageResources);
        } else {
            if (this.usedResources != null) {
                Iterator iter = this.usedResources.iterator();
                while (iter.hasNext()) {
                    PSResource res = (PSResource)iter.next();
                    if (this.documentSuppliedResources != null && this.documentSuppliedResources.contains(res)) continue;
                    this.registerNeededResource(res);
                }
            }
            new DSCCommentDocumentNeededResources(this.documentNeededResources).generate(gen);
            new DSCCommentDocumentSuppliedResources(this.documentSuppliedResources).generate(gen);
        }
    }
}

