/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.lifecycle.ApplyRequestValuesPhase;
import com.sun.faces.lifecycle.InvokeApplicationPhase;
import com.sun.faces.lifecycle.Phase;
import com.sun.faces.lifecycle.ProcessValidationsPhase;
import com.sun.faces.lifecycle.RenderResponsePhase;
import com.sun.faces.lifecycle.RestoreViewPhase;
import com.sun.faces.lifecycle.UpdateModelValuesPhase;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.ResponseStateManager;
import javax.servlet.http.HttpServletRequest;

public class LifecycleImpl
extends Lifecycle {
    private static Logger LOGGER = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.lifecycle");
    private static Logger TIMING_LOGGER = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.timing");
    private CopyOnWriteArrayList<PhaseListener> listeners = new CopyOnWriteArrayList();
    private Phase[] phases = new Phase[]{null, new RestoreViewPhase(), new ApplyRequestValuesPhase(), new ProcessValidationsPhase(), new UpdateModelValuesPhase(), new InvokeApplicationPhase()};
    private Phase response = new RenderResponsePhase();

    public void execute(FacesContext context) throws FacesException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("execute(" + context + ")");
        }
        for (int i = 1; i < this.phases.length && !context.getRenderResponse() && !context.getResponseComplete(); ++i) {
            PhaseId phaseId = (PhaseId)PhaseId.VALUES.get(i);
            this.phase(phaseId, this.phases[i], context);
            if (!this.reload(phaseId, context)) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Skipping rest of execute() because of a reload");
            }
            context.renderResponse();
        }
    }

    public void render(FacesContext context) throws FacesException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("render(" + context + ")");
        }
        if (!context.getResponseComplete()) {
            this.phase(PhaseId.RENDER_RESPONSE, this.response, context);
        }
    }

    public void addPhaseListener(PhaseListener listener) {
        if (listener == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "listener"));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("addPhaseListener(" + listener.getPhaseId().toString() + "," + listener);
        }
        this.listeners.add(listener);
    }

    public PhaseListener[] getPhaseListeners() {
        return this.listeners.toArray(new PhaseListener[this.listeners.size()]);
    }

    public void removePhaseListener(PhaseListener listener) {
        if (listener == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "listener"));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("removePhaseListener(" + listener.getPhaseId().toString() + "," + listener);
        }
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void phase(PhaseId phaseId, Phase phase, FacesContext context) throws FacesException {
        Throwable ex;
        boolean exceptionThrown;
        block29: {
            PhaseListener listener3222;
            PhaseEvent event3222;
            ListIterator<PhaseListener> listenersIterator;
            block28: {
                block27: {
                    exceptionThrown = false;
                    ex = null;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("phase(" + phaseId.toString() + ',' + context + ')');
                    }
                    if (PhaseId.RESTORE_VIEW.equals(phaseId)) {
                        Util.getViewHandler(context).initView(context);
                    }
                    listenersIterator = this.listeners.listIterator();
                    try {
                        if (listenersIterator.hasNext()) {
                            PhaseEvent event2 = new PhaseEvent(context, phaseId, (Lifecycle)this);
                            while (listenersIterator.hasNext()) {
                                PhaseListener listener2 = listenersIterator.next();
                                if (!phaseId.equals(listener2.getPhaseId()) && !PhaseId.ANY_PHASE.equals(listener2.getPhaseId())) continue;
                                listener2.beforePhase(event2);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.warning("phase(" + phaseId.toString() + ',' + context + ") threw exception: " + e + ' ' + e.getMessage() + "\n" + Util.getStackTraceString(e));
                        }
                        if (!listenersIterator.hasPrevious()) break block27;
                        listenersIterator.previous();
                    }
                }
                if (this.skipping(phaseId, context)) break block28;
                long start = System.currentTimeMillis();
                phase.execute(context);
                long stop = System.currentTimeMillis();
                if (!TIMING_LOGGER.isLoggable(Level.FINE)) break block28;
                TIMING_LOGGER.fine("TIMING: Exectution time for phase '" + phaseId.toString() + "': " + (stop - start));
            }
            Object var12_13 = null;
            try {
                if (listenersIterator.hasPrevious()) {
                    event3222 = new PhaseEvent(context, phaseId, (Lifecycle)this);
                    while (listenersIterator.hasPrevious()) {
                        listener3222 = listenersIterator.previous();
                        if (!phaseId.equals(listener3222.getPhaseId()) && !PhaseId.ANY_PHASE.equals(listener3222.getPhaseId())) continue;
                        listener3222.afterPhase(event3222);
                    }
                }
                break block29;
            }
            catch (Throwable e2) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("phase(" + phaseId.toString() + ',' + context + ") threw exception: " + e2 + ' ' + e2.getMessage() + "\n" + Util.getStackTraceString(e2));
                }
                break block29;
            }
            {
                catch (Exception e) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, "executePhase(" + phaseId.toString() + ',' + context + ") threw exception", e);
                    }
                    ex = e;
                    exceptionThrown = true;
                    var12_13 = null;
                    try {
                        if (listenersIterator.hasPrevious()) {
                            event3222 = new PhaseEvent(context, phaseId, (Lifecycle)this);
                            while (listenersIterator.hasPrevious()) {
                                listener3222 = listenersIterator.previous();
                                if (!phaseId.equals(listener3222.getPhaseId()) && !PhaseId.ANY_PHASE.equals(listener3222.getPhaseId())) continue;
                                listener3222.afterPhase(event3222);
                            }
                        }
                        break block29;
                    }
                    catch (Throwable e2) {
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.warning("phase(" + phaseId.toString() + ',' + context + ") threw exception: " + e2 + ' ' + e2.getMessage() + "\n" + Util.getStackTraceString(e2));
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block30: {
                    Object var12_14 = null;
                    try {
                        if (listenersIterator.hasPrevious()) {
                            PhaseEvent event3222 = new PhaseEvent(context, phaseId, (Lifecycle)this);
                            while (listenersIterator.hasPrevious()) {
                                PhaseListener listener3222 = listenersIterator.previous();
                                if (!phaseId.equals(listener3222.getPhaseId()) && !PhaseId.ANY_PHASE.equals(listener3222.getPhaseId())) continue;
                                listener3222.afterPhase(event3222);
                            }
                        }
                    }
                    catch (Throwable e2) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block30;
                        LOGGER.warning("phase(" + phaseId.toString() + ',' + context + ") threw exception: " + e2 + ' ' + e2.getMessage() + "\n" + Util.getStackTraceString(e2));
                    }
                }
                throw throwable;
            }
        }
        if (exceptionThrown) {
            while (ex.getCause() != null) {
                ex = ex.getCause();
            }
            if (!(ex instanceof FacesException)) {
                ex = new FacesException(ex);
            }
            throw (FacesException)ex;
        }
    }

    private boolean reload(PhaseId phaseId, FacesContext context) {
        if (!PhaseId.RESTORE_VIEW.equals(phaseId)) {
            return false;
        }
        if (!(context.getExternalContext().getRequest() instanceof HttpServletRequest)) {
            return false;
        }
        String renderkitId = context.getApplication().getViewHandler().calculateRenderKitId(context);
        ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, renderkitId);
        boolean postback = rsm.isPostback(context);
        return !postback;
    }

    private boolean skipping(PhaseId phaseId, FacesContext context) {
        if (context.getResponseComplete()) {
            return true;
        }
        return context.getRenderResponse() && !PhaseId.RENDER_RESPONSE.equals(phaseId);
    }
}

