/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.AttributeUtils;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.InnerClass;
import org.aspectj.apache.bcel.classfile.InnerClasses;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.Modifiers;
import org.aspectj.apache.bcel.classfile.Node;
import org.aspectj.apache.bcel.classfile.Signature;
import org.aspectj.apache.bcel.classfile.SourceFile;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeAnnotations;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.apache.bcel.util.ClassQueue;
import org.aspectj.apache.bcel.util.ClassVector;
import org.aspectj.apache.bcel.util.Repository;
import org.aspectj.apache.bcel.util.SyntheticRepository;

public class JavaClass
extends Modifiers
implements Cloneable,
Node {
    private String file_name;
    private String package_name;
    private String source_file_name;
    private int class_name_index;
    private int superclass_name_index;
    private String class_name;
    private String superclass_name;
    private int major;
    private int minor;
    private ConstantPool constant_pool;
    private int[] interfaces;
    private String[] interface_names;
    private Field[] fields;
    private Method[] methods;
    private Attribute[] attributes;
    private AnnotationGen[] annotations;
    private boolean isGeneric = false;
    private boolean isAnonymous = false;
    private boolean isNested = false;
    private boolean computedNestedTypeStatus = false;
    public static final byte HEAP = 1;
    public static final byte FILE = 2;
    public static final byte ZIP = 3;
    static boolean debug;
    static char sep;
    private boolean annotationsOutOfDate = true;
    private String signatureAttributeString = null;
    private Signature signatureAttribute = null;
    private boolean searchedForSignatureAttribute = false;
    private static final String[] NO_INTERFACE_NAMES;
    private transient Repository repository = null;

    static {
        String sep;
        debug = false;
        JavaClass.sep = (char)47;
        NO_INTERFACE_NAMES = new String[0];
        String debug = System.getProperty("JavaClass.debug");
        if (debug != null) {
            JavaClass.debug = new Boolean(debug);
        }
        if ((sep = System.getProperty("file.separator")) != null) {
            try {
                JavaClass.sep = sep.charAt(0);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public JavaClass(int class_name_index, int superclass_name_index, String file_name, int major, int minor, int access_flags, ConstantPool constant_pool, int[] interfaces, Field[] fields, Method[] methods, Attribute[] attributes) {
        if (interfaces == null) {
            interfaces = new int[]{};
        }
        if (attributes == null) {
            this.attributes = Attribute.NoAttributes;
        }
        if (fields == null) {
            fields = new Field[]{};
        }
        if (methods == null) {
            methods = new Method[]{};
        }
        this.class_name_index = class_name_index;
        this.superclass_name_index = superclass_name_index;
        this.file_name = file_name;
        this.major = major;
        this.minor = minor;
        this.modifiers = access_flags;
        this.constant_pool = constant_pool;
        this.interfaces = interfaces;
        this.fields = fields;
        this.methods = methods;
        this.attributes = attributes;
        this.annotationsOutOfDate = true;
        SourceFile sfAttribute = AttributeUtils.getSourceFileAttribute(attributes);
        this.source_file_name = sfAttribute == null ? "<Unknown>" : sfAttribute.getSourceFileName();
        this.class_name = constant_pool.getConstantString(class_name_index, (byte)7);
        this.class_name = Utility.compactClassName(this.class_name, false);
        int index = this.class_name.lastIndexOf(46);
        this.package_name = index < 0 ? "" : this.class_name.substring(0, index);
        if (superclass_name_index > 0) {
            this.superclass_name = constant_pool.getConstantString(superclass_name_index, (byte)7);
            this.superclass_name = Utility.compactClassName(this.superclass_name, false);
        } else {
            this.superclass_name = "java.lang.Object";
        }
        if (interfaces.length == 0) {
            this.interface_names = NO_INTERFACE_NAMES;
        } else {
            this.interface_names = new String[interfaces.length];
            int i = 0;
            while (i < interfaces.length) {
                String str = constant_pool.getConstantString(interfaces[i], (byte)7);
                this.interface_names[i] = Utility.compactClassName(str, false);
                ++i;
            }
        }
    }

    public void accept(ClassVisitor v) {
        v.visitJavaClass(this);
    }

    static final void Debug(String str) {
        if (debug) {
            System.out.println(str);
        }
    }

    public void dump(File file) throws IOException {
        File dir;
        String parent = file.getParent();
        if (parent != null && (dir = new File(parent)) != null) {
            dir.mkdirs();
        }
        this.dump(new DataOutputStream(new FileOutputStream(file)));
    }

    public void dump(String file_name) throws IOException {
        this.dump(new File(file_name));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes() {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(s);
        try {
            try {
                this.dump(ds);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                ds.close();
                throw throwable;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
        {
            Object var5_6 = null;
        }
        try {}
        catch (IOException e2) {
            e2.printStackTrace();
            return s.toByteArray();
        }
        ds.close();
        return s.toByteArray();
    }

    public void dump(OutputStream file) throws IOException {
        this.dump(new DataOutputStream(file));
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeInt(-889275714);
        file.writeShort(this.minor);
        file.writeShort(this.major);
        this.constant_pool.dump(file);
        file.writeShort(this.modifiers);
        file.writeShort(this.class_name_index);
        file.writeShort(this.superclass_name_index);
        file.writeShort(this.interfaces.length);
        int i = 0;
        while (i < this.interfaces.length) {
            file.writeShort(this.interfaces[i]);
            ++i;
        }
        file.writeShort(this.fields.length);
        i = 0;
        while (i < this.fields.length) {
            this.fields[i].dump(file);
            ++i;
        }
        file.writeShort(this.methods.length);
        i = 0;
        while (i < this.methods.length) {
            this.methods[i].dump(file);
            ++i;
        }
        AttributeUtils.writeAttributes(this.attributes, file);
        file.close();
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public AnnotationGen[] getAnnotations() {
        if (this.annotationsOutOfDate) {
            ArrayList accumulatedAnnotations = new ArrayList();
            int i = 0;
            while (i < this.attributes.length) {
                Attribute attribute = this.attributes[i];
                if (attribute instanceof RuntimeAnnotations) {
                    RuntimeAnnotations runtimeAnnotations = (RuntimeAnnotations)attribute;
                    accumulatedAnnotations.addAll(runtimeAnnotations.getAnnotations());
                }
                ++i;
            }
            this.annotations = accumulatedAnnotations.toArray(new AnnotationGen[0]);
            this.annotationsOutOfDate = false;
        }
        return this.annotations;
    }

    public String getClassName() {
        return this.class_name;
    }

    public String getPackageName() {
        return this.package_name;
    }

    public int getClassNameIndex() {
        return this.class_name_index;
    }

    public ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public String getFileName() {
        return this.file_name;
    }

    public String[] getInterfaceNames() {
        return this.interface_names;
    }

    public int[] getInterfaceIndices() {
        return this.interfaces;
    }

    public int getMajor() {
        return this.major;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public Method getMethod(java.lang.reflect.Method m) {
        int i = 0;
        while (i < this.methods.length) {
            Method method = this.methods[i];
            if (m.getName().equals(method.getName()) && m.getModifiers() == method.getModifiers() && Type.getSignature(m).equals(method.getSignature())) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public Method getMethod(Constructor c) {
        int i = 0;
        while (i < this.methods.length) {
            Method method = this.methods[i];
            if (method.getName().equals("<init>") && c.getModifiers() == method.getModifiers() && Type.getSignature(c).equals(method.getSignature())) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public Field getField(java.lang.reflect.Field field) {
        int i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].getName().equals(field.getName())) {
                return this.fields[i];
            }
            ++i;
        }
        return null;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getSourceFileName() {
        return this.source_file_name;
    }

    public String getSuperclassName() {
        return this.superclass_name;
    }

    public int getSuperclassNameIndex() {
        return this.superclass_name_index;
    }

    public void setAttributes(Attribute[] attributes) {
        this.attributes = attributes;
        this.annotationsOutOfDate = true;
    }

    public void setClassName(String class_name) {
        this.class_name = class_name;
    }

    public void setClassNameIndex(int class_name_index) {
        this.class_name_index = class_name_index;
    }

    public void setConstantPool(ConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }

    public void setFields(Field[] fields) {
        this.fields = fields;
    }

    public void setFileName(String file_name) {
        this.file_name = file_name;
    }

    public void setInterfaceNames(String[] interface_names) {
        this.interface_names = interface_names;
    }

    public void setInterfaces(int[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public void setMethods(Method[] methods) {
        this.methods = methods;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public void setSourceFileName(String source_file_name) {
        this.source_file_name = source_file_name;
    }

    public void setSuperclassName(String superclass_name) {
        this.superclass_name = superclass_name;
    }

    public void setSuperclassNameIndex(int superclass_name_index) {
        this.superclass_name_index = superclass_name_index;
    }

    public String toString() {
        int i;
        String access = Utility.accessToString(this.modifiers, true);
        access = access.equals("") ? "" : String.valueOf(access) + " ";
        StringBuffer buf = new StringBuffer(String.valueOf(access) + Utility.classOrInterface(this.modifiers) + " " + this.class_name + " extends " + Utility.compactClassName(this.superclass_name, false) + '\n');
        int size = this.interfaces.length;
        if (size > 0) {
            buf.append("implements\t\t");
            i = 0;
            while (i < size) {
                buf.append(this.interface_names[i]);
                if (i < size - 1) {
                    buf.append(", ");
                }
                ++i;
            }
            buf.append('\n');
        }
        buf.append("filename\t\t" + this.file_name + '\n');
        buf.append("compiled from\t\t" + this.source_file_name + '\n');
        buf.append("compiler version\t" + this.major + "." + this.minor + '\n');
        buf.append("access flags\t\t" + this.modifiers + '\n');
        buf.append("constant pool\t\t" + this.constant_pool.getLength() + " entries\n");
        buf.append("ACC_SUPER flag\t\t" + this.isSuper() + "\n");
        if (this.attributes.length > 0) {
            buf.append("\nAttribute(s):\n");
            i = 0;
            while (i < this.attributes.length) {
                buf.append(JavaClass.indent(this.attributes[i]));
                ++i;
            }
        }
        if (this.annotations != null && this.annotations.length > 0) {
            buf.append("\nAnnotation(s):\n");
            i = 0;
            while (i < this.annotations.length) {
                buf.append(JavaClass.indent(this.annotations[i]));
                ++i;
            }
        }
        if (this.fields.length > 0) {
            buf.append("\n" + this.fields.length + " fields:\n");
            i = 0;
            while (i < this.fields.length) {
                buf.append("\t" + this.fields[i] + '\n');
                ++i;
            }
        }
        if (this.methods.length > 0) {
            buf.append("\n" + this.methods.length + " methods:\n");
            i = 0;
            while (i < this.methods.length) {
                buf.append("\t" + this.methods[i] + '\n');
                ++i;
            }
        }
        return buf.toString();
    }

    private static final String indent(Object obj) {
        StringTokenizer tok = new StringTokenizer(obj.toString(), "\n");
        StringBuffer buf = new StringBuffer();
        while (tok.hasMoreTokens()) {
            buf.append("\t" + tok.nextToken() + "\n");
        }
        return buf.toString();
    }

    public JavaClass copy() {
        JavaClass c = null;
        try {
            c = (JavaClass)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        c.constant_pool = this.constant_pool.copy();
        c.interfaces = (int[])this.interfaces.clone();
        c.interface_names = (String[])this.interface_names.clone();
        c.fields = new Field[this.fields.length];
        int i = 0;
        while (i < this.fields.length) {
            c.fields[i] = this.fields[i].copy(c.constant_pool);
            ++i;
        }
        c.methods = new Method[this.methods.length];
        i = 0;
        while (i < this.methods.length) {
            c.methods[i] = this.methods[i].copy(c.constant_pool);
            ++i;
        }
        c.attributes = AttributeUtils.copy(this.attributes, c.constant_pool);
        return c;
    }

    public final boolean isSuper() {
        return (this.modifiers & 0x20) != 0;
    }

    public final boolean isClass() {
        return (this.modifiers & 0x200) == 0;
    }

    public final boolean isAnonymous() {
        this.computeNestedTypeStatus();
        return this.isAnonymous;
    }

    public final boolean isNested() {
        this.computeNestedTypeStatus();
        return this.isNested;
    }

    private final void computeNestedTypeStatus() {
        if (this.computedNestedTypeStatus) {
            return;
        }
        int i = 0;
        while (i < this.attributes.length) {
            if (this.attributes[i] instanceof InnerClasses) {
                InnerClass[] innerClasses = ((InnerClasses)this.attributes[i]).getInnerClasses();
                int j = 0;
                while (j < innerClasses.length) {
                    boolean innerClassAttributeRefersToMe = false;
                    String inner_class_name = this.constant_pool.getConstantString(innerClasses[j].getInnerClassIndex(), (byte)7);
                    if ((inner_class_name = Utility.compactClassName(inner_class_name)).equals(this.getClassName())) {
                        innerClassAttributeRefersToMe = true;
                    }
                    if (innerClassAttributeRefersToMe) {
                        this.isNested = true;
                        if (innerClasses[j].getInnerNameIndex() == 0) {
                            this.isAnonymous = true;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.computedNestedTypeStatus = true;
    }

    public final boolean isAnnotation() {
        return (this.modifiers & 0x2000) != 0;
    }

    public final boolean isEnum() {
        return (this.modifiers & 0x4000) != 0;
    }

    public Repository getRepository() {
        if (this.repository == null) {
            this.repository = SyntheticRepository.getInstance();
        }
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public final boolean instanceOf(JavaClass super_class) {
        if (this.equals(super_class)) {
            return true;
        }
        JavaClass[] super_classes = this.getSuperClasses();
        int i = 0;
        while (i < super_classes.length) {
            if (super_classes[i].equals(super_class)) {
                return true;
            }
            ++i;
        }
        if (super_class.isInterface()) {
            return this.implementationOf(super_class);
        }
        return false;
    }

    public boolean implementationOf(JavaClass inter) {
        if (!inter.isInterface()) {
            throw new IllegalArgumentException(String.valueOf(inter.getClassName()) + " is no interface");
        }
        if (this.equals(inter)) {
            return true;
        }
        JavaClass[] super_interfaces = this.getAllInterfaces();
        int i = 0;
        while (i < super_interfaces.length) {
            if (super_interfaces[i].equals(inter)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public JavaClass getSuperClass() {
        if ("java.lang.Object".equals(this.getClassName())) {
            return null;
        }
        try {
            return this.getRepository().loadClass(this.getSuperclassName());
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
            return null;
        }
    }

    public JavaClass[] getSuperClasses() {
        JavaClass clazz = this;
        ClassVector vec = new ClassVector();
        clazz = clazz.getSuperClass();
        while (clazz != null) {
            vec.addElement(clazz);
            clazz = clazz.getSuperClass();
        }
        return vec.toArray();
    }

    public JavaClass[] getInterfaces() {
        String[] interfaces = this.getInterfaceNames();
        JavaClass[] classes = new JavaClass[interfaces.length];
        try {
            int i = 0;
            while (i < interfaces.length) {
                classes[i] = this.getRepository().loadClass(interfaces[i]);
                ++i;
            }
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
            return null;
        }
        return classes;
    }

    public JavaClass[] getAllInterfaces() {
        ClassQueue queue = new ClassQueue();
        ClassVector vec = new ClassVector();
        queue.enqueue(this);
        while (!queue.empty()) {
            JavaClass clazz = queue.dequeue();
            JavaClass souper = clazz.getSuperClass();
            JavaClass[] interfaces = clazz.getInterfaces();
            if (clazz.isInterface()) {
                vec.addElement(clazz);
            } else if (souper != null) {
                queue.enqueue(souper);
            }
            int i = 0;
            while (i < interfaces.length) {
                queue.enqueue(interfaces[i]);
                ++i;
            }
        }
        return vec.toArray();
    }

    public final String getGenericSignature() {
        this.loadGenericSignatureInfoIfNecessary();
        return this.signatureAttributeString;
    }

    public boolean isGeneric() {
        this.loadGenericSignatureInfoIfNecessary();
        return this.isGeneric;
    }

    private void loadGenericSignatureInfoIfNecessary() {
        if (!this.searchedForSignatureAttribute) {
            this.signatureAttribute = AttributeUtils.getSignatureAttribute(this.attributes);
            this.signatureAttributeString = this.signatureAttribute == null ? null : this.signatureAttribute.getSignature();
            this.isGeneric = this.signatureAttribute != null && this.signatureAttributeString.charAt(0) == '<';
            this.searchedForSignatureAttribute = true;
        }
    }

    public final Signature.ClassSignature getGenericClassTypeSignature() {
        this.loadGenericSignatureInfoIfNecessary();
        if (this.signatureAttribute != null) {
            return this.signatureAttribute.asClassSignature();
        }
        return null;
    }
}

