/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolesInterceptor
extends AbstractInterceptor {
    private List<String> allowedRoles = new ArrayList<String>();
    private List<String> disallowedRoles = new ArrayList<String>();

    public void setAllowedRoles(String roles) {
        this.allowedRoles = this.stringToList(roles);
    }

    public void setDisallowedRoles(String roles) {
        this.disallowedRoles = this.stringToList(roles);
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        String result = null;
        result = !this.isAllowed(request, invocation.getAction()) ? this.handleRejection(invocation, response) : invocation.invoke();
        return result;
    }

    protected List<String> stringToList(String val) {
        if (val != null) {
            String[] list = val.split("[ ]*,[ ]*");
            return Arrays.asList(list);
        }
        return Collections.EMPTY_LIST;
    }

    protected boolean isAllowed(HttpServletRequest request, Object action) {
        if (this.allowedRoles.size() > 0) {
            boolean result = false;
            for (String role : this.allowedRoles) {
                if (!request.isUserInRole(role)) continue;
                result = true;
            }
            return result;
        }
        if (this.disallowedRoles.size() > 0) {
            for (String role : this.disallowedRoles) {
                if (!request.isUserInRole(role)) continue;
                return false;
            }
        }
        return true;
    }

    protected String handleRejection(ActionInvocation invocation, HttpServletResponse response) throws Exception {
        response.sendError(403);
        return null;
    }
}

