/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.components.ClosingUIBean;
import org.apache.struts2.components.Form;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

public abstract class FormButton
extends ClosingUIBean {
    static final String BUTTONTYPE_INPUT = "input";
    static final String BUTTONTYPE_BUTTON = "button";
    static final String BUTTONTYPE_IMAGE = "image";
    protected String action;
    protected String method;
    protected String align;
    protected String type;
    protected ActionMapper actionMapper;

    public FormButton(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public void evaluateExtraParams() {
        super.evaluateExtraParams();
        if (this.align == null) {
            this.align = "right";
        }
        String submitType = BUTTONTYPE_INPUT;
        if (this.type != null && (BUTTONTYPE_BUTTON.equalsIgnoreCase(this.type) || this.supportsImageType() && BUTTONTYPE_IMAGE.equalsIgnoreCase(this.type))) {
            submitType = this.type;
        }
        this.addParameter("type", submitType);
        if (!BUTTONTYPE_INPUT.equals(submitType) && this.label == null) {
            this.addParameter("label", this.getParameters().get("nameValue"));
        }
        if (this.action != null || this.method != null) {
            String name;
            if (this.action != null) {
                ActionMapping mapping = new ActionMapping();
                mapping.setName(this.findString(this.action));
                if (this.method != null) {
                    mapping.setMethod(this.findString(this.method));
                }
                mapping.setExtension("");
                name = "action:" + this.actionMapper.getUriFromActionMapping(mapping);
            } else {
                name = "method:" + this.findString(this.method);
            }
            this.addParameter("name", name);
        }
        this.addParameter("align", this.findString(this.align));
    }

    protected void populateComponentHtmlId(Form form) {
        String _tmp_id = "";
        if (this.id != null) {
            _tmp_id = this.findStringIfAltSyntax(this.id);
        } else {
            if (form != null && form.getParameters().get("id") != null) {
                _tmp_id = _tmp_id + form.getParameters().get("id").toString() + "_";
            }
            if (this.name != null) {
                _tmp_id = _tmp_id + this.escape(this.name);
            } else if (this.action != null || this.method != null) {
                if (this.action != null) {
                    _tmp_id = _tmp_id + this.escape(this.action);
                }
                if (this.method != null) {
                    _tmp_id = _tmp_id + "_" + this.escape(this.method);
                }
            } else if (form != null) {
                _tmp_id = _tmp_id + form.getSequence();
            }
        }
        this.addParameter("id", _tmp_id);
    }

    protected abstract boolean supportsImageType();

    @Inject
    public void setActionMapper(ActionMapper mapper) {
        this.actionMapper = mapper;
    }

    @StrutsTagAttribute(description="Set action attribute.")
    public void setAction(String action) {
        this.action = action;
    }

    @StrutsTagAttribute(description="Set method attribute.")
    public void setMethod(String method) {
        this.method = method;
    }

    @StrutsTagAttribute(description="HTML align attribute.")
    public void setAlign(String align) {
        this.align = align;
    }

    @StrutsTagAttribute(description="The type of submit to use. Valid values are <i>input</i>, <i>button</i> and <i>image</i>.", defaultValue="input")
    public void setType(String type) {
        this.type = type;
    }
}

