/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.StrutsException;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.util.FastByteArrayOutputStream;
import org.apache.struts2.views.jsp.TagUtils;
import org.apache.struts2.views.util.ContextUtil;
import org.apache.struts2.views.util.UrlHelper;

public class Component {
    public static final String COMPONENT_STACK = "__component_stack";
    protected ValueStack stack;
    protected Map parameters;
    protected ActionMapper actionMapper;

    public Component(ValueStack stack) {
        this.stack = stack;
        this.parameters = new LinkedHashMap();
        this.getComponentStack().push(this);
    }

    private String getComponentName() {
        Class<?> c = this.getClass();
        String name = c.getName();
        int dot = name.lastIndexOf(46);
        return name.substring(dot + 1).toLowerCase();
    }

    @Inject
    public void setActionMapper(ActionMapper mapper) {
        this.actionMapper = mapper;
    }

    public ValueStack getStack() {
        return this.stack;
    }

    public Stack getComponentStack() {
        Stack componentStack = (Stack)this.stack.getContext().get(COMPONENT_STACK);
        if (componentStack == null) {
            componentStack = new Stack();
            this.stack.getContext().put(COMPONENT_STACK, componentStack);
        }
        return componentStack;
    }

    public boolean start(Writer writer) {
        return true;
    }

    public boolean end(Writer writer, String body) {
        return this.end(writer, body, true);
    }

    protected boolean end(Writer writer, String body, boolean popComponentStack) {
        assert (body != null);
        try {
            writer.write(body);
        }
        catch (IOException e) {
            throw new StrutsException("IOError while writing the body: " + e.getMessage(), e);
        }
        if (popComponentStack) {
            this.popComponentStack();
        }
        return false;
    }

    protected void popComponentStack() {
        this.getComponentStack().pop();
    }

    protected Component findAncestor(Class clazz) {
        Stack componentStack = this.getComponentStack();
        int currPosition = componentStack.search(this);
        if (currPosition >= 0) {
            int start;
            for (int i = start = componentStack.size() - currPosition - 1; i >= 0; --i) {
                Component component = (Component)componentStack.get(i);
                if (!clazz.isAssignableFrom(component.getClass()) || component == this) continue;
                return component;
            }
        }
        return null;
    }

    protected String findString(String expr) {
        return (String)this.findValue(expr, String.class);
    }

    protected String findString(String expr, String field, String errorMsg) {
        if (expr == null) {
            throw this.fieldError(field, errorMsg, null);
        }
        return this.findString(expr);
    }

    protected StrutsException fieldError(String field, String errorMsg, Exception e) {
        String msg = "tag '" + this.getComponentName() + "', field '" + field + (this.parameters != null && this.parameters.containsKey("name") ? "', name '" + this.parameters.get("name") : "") + "': " + errorMsg;
        throw new StrutsException(msg, e);
    }

    protected Object findValue(String expr) {
        if (expr == null) {
            return null;
        }
        expr = this.stripExpressionIfAltSyntax(expr);
        return this.getStack().findValue(expr);
    }

    protected String stripExpressionIfAltSyntax(String expr) {
        return Component.stripExpressionIfAltSyntax(this.stack, expr);
    }

    public static String stripExpressionIfAltSyntax(ValueStack stack, String expr) {
        if (Component.altSyntax(stack) && expr.startsWith("%{") && expr.endsWith("}")) {
            return expr.substring(2, expr.length() - 1);
        }
        return expr;
    }

    public static boolean altSyntax(ValueStack stack) {
        return ContextUtil.isUseAltSyntax(stack.getContext());
    }

    public boolean altSyntax() {
        return Component.altSyntax(this.stack);
    }

    protected String completeExpressionIfAltSyntax(String expr) {
        if (this.altSyntax()) {
            return "%{" + expr + "}";
        }
        return expr;
    }

    protected String findStringIfAltSyntax(String expr) {
        if (this.altSyntax()) {
            return this.findString(expr);
        }
        return expr;
    }

    protected Object findValue(String expr, String field, String errorMsg) {
        if (expr == null) {
            throw this.fieldError(field, errorMsg, null);
        }
        Object value = null;
        Exception problem = null;
        try {
            value = this.findValue(expr);
        }
        catch (Exception e) {
            problem = e;
        }
        if (value == null) {
            throw this.fieldError(field, errorMsg, problem);
        }
        return value;
    }

    protected Object findValue(String expr, Class toType) {
        if (this.altSyntax() && toType == String.class) {
            return TextParseUtil.translateVariables((char)'%', (String)expr, (ValueStack)this.stack);
        }
        expr = this.stripExpressionIfAltSyntax(expr);
        return this.getStack().findValue(expr, toType);
    }

    protected String determineActionURL(String action, String namespace, String method, HttpServletRequest req, HttpServletResponse res, Map parameters, String scheme, boolean includeContext, boolean encodeResult, boolean forceAddSchemeHostAndPort, boolean escapeAmp) {
        String finalAction = this.findString(action);
        String finalMethod = method != null ? this.findString(method) : method;
        String finalNamespace = this.determineNamespace(namespace, this.getStack(), req);
        ActionMapping mapping = new ActionMapping(finalAction, finalNamespace, finalMethod, parameters);
        String uri = this.actionMapper.getUriFromActionMapping(mapping);
        return UrlHelper.buildUrl(uri, req, res, parameters, scheme, includeContext, encodeResult, forceAddSchemeHostAndPort, escapeAmp);
    }

    protected String determineNamespace(String namespace, ValueStack stack, HttpServletRequest req) {
        String result = namespace == null ? TagUtils.buildNamespace(this.actionMapper, stack, req) : this.findString(namespace);
        if (result == null) {
            result = "";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyParams(Map params) {
        this.stack.push((Object)this.parameters);
        this.stack.push((Object)this);
        try {
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                this.stack.setValue(key, entry.getValue());
            }
        }
        finally {
            this.stack.pop();
            this.stack.pop();
        }
    }

    protected String toString(Throwable t) {
        FastByteArrayOutputStream bout = new FastByteArrayOutputStream();
        PrintWriter wrt = new PrintWriter(bout);
        t.printStackTrace(wrt);
        wrt.close();
        return bout.toString();
    }

    public Map getParameters() {
        return this.parameters;
    }

    public void addAllParameters(Map params) {
        this.parameters.putAll(params);
    }

    public void addParameter(String key, Object value) {
        if (key != null) {
            Map params = this.getParameters();
            if (value == null) {
                params.remove(key);
            } else {
                params.put(key, value);
            }
        }
    }

    public boolean usesBody() {
        return false;
    }
}

