/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.loader;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.loader.AbstractSerialStateHolder;
import org.apache.ibatis.executor.loader.ResultLoaderMap;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.property.PropertyCopier;
import org.apache.ibatis.reflection.property.PropertyNamer;

public abstract class AbstractEnhancedDeserializationProxy {
    protected static final String FINALIZE_METHOD = "finalize";
    protected static final String WRITE_REPLACE_METHOD = "writeReplace";
    private Class<?> type;
    private Map<String, ResultLoaderMap.LoadPair> unloadedProperties;
    private ObjectFactory objectFactory;
    private List<Class<?>> constructorArgTypes;
    private List<Object> constructorArgs;
    private final Object reloadingPropertyLock;
    private boolean reloadingProperty;

    protected AbstractEnhancedDeserializationProxy(Class<?> type, Map<String, ResultLoaderMap.LoadPair> unloadedProperties, ObjectFactory objectFactory, List<Class<?>> constructorArgTypes, List<Object> constructorArgs) {
        this.type = type;
        this.unloadedProperties = unloadedProperties;
        this.objectFactory = objectFactory;
        this.constructorArgTypes = constructorArgTypes;
        this.constructorArgs = constructorArgs;
        this.reloadingPropertyLock = new Object();
        this.reloadingProperty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object invoke(Object enhanced, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        try {
            if (WRITE_REPLACE_METHOD.equals(methodName)) {
                Object original = this.constructorArgTypes.isEmpty() ? this.objectFactory.create(this.type) : this.objectFactory.create(this.type, this.constructorArgTypes, this.constructorArgs);
                PropertyCopier.copyBeanProperties(this.type, enhanced, original);
                return this.newSerialStateHolder(original, this.unloadedProperties, this.objectFactory, this.constructorArgTypes, this.constructorArgs);
            }
            Object original = this.reloadingPropertyLock;
            synchronized (original) {
                String property;
                String propertyKey;
                if (!FINALIZE_METHOD.equals(methodName) && PropertyNamer.isProperty(methodName) && !this.reloadingProperty && this.unloadedProperties.containsKey(propertyKey = (property = PropertyNamer.methodToProperty(methodName)).toUpperCase(Locale.ENGLISH))) {
                    ResultLoaderMap.LoadPair loadPair = this.unloadedProperties.remove(propertyKey);
                    if (loadPair != null) {
                        try {
                            this.reloadingProperty = true;
                            loadPair.load(enhanced);
                        }
                        finally {
                            this.reloadingProperty = false;
                        }
                    } else {
                        throw new ExecutorException("An attempt has been made to read a not loaded lazy property '" + property + "' of a disconnected object");
                    }
                }
                return enhanced;
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.unwrapThrowable(t);
        }
    }

    protected abstract AbstractSerialStateHolder newSerialStateHolder(Object var1, Map<String, ResultLoaderMap.LoadPair> var2, ObjectFactory var3, List<Class<?>> var4, List<Object> var5);
}

