/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.log4j12;

import java.io.Serializable;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.slf4j.Marker;
import org.slf4j.helpers.LegacyAbstractLogger;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.helpers.NormalizedParameters;
import org.slf4j.spi.LocationAwareLogger;

public final class Log4jLoggerAdapter
extends LegacyAbstractLogger
implements LocationAwareLogger,
Serializable {
    private static final long serialVersionUID = 6182834493563598289L;
    final transient Logger logger;
    static final String FQCN = Log4jLoggerAdapter.class.getName();
    final boolean traceCapable;

    Log4jLoggerAdapter(Logger logger) {
        this.logger = logger;
        this.name = logger.getName();
        this.traceCapable = this.isTraceCapable();
    }

    private boolean isTraceCapable() {
        try {
            this.logger.isTraceEnabled();
            return true;
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }

    public boolean isTraceEnabled() {
        if (this.traceCapable) {
            return this.logger.isTraceEnabled();
        }
        return this.logger.isDebugEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    public void log(Marker marker, String callerFQCN, int level, String msg, Object[] arguments, Throwable t) {
        Level log4jLevel = this.toLog4jLevel(level);
        NormalizedParameters np = NormalizedParameters.normalize((String)msg, (Object[])arguments, (Throwable)t);
        String formattedMessage = MessageFormatter.basicArrayFormat((String)np.getMessage(), (Object[])np.getArguments());
        this.logger.log(callerFQCN, (Priority)log4jLevel, (Object)formattedMessage, np.getThrowable());
    }

    protected void handleNormalizedLoggingCall(org.slf4j.event.Level level, Marker marker, String msg, Object[] arguments, Throwable throwable) {
        Level log4jLevel = this.toLog4jLevel(level.toInt());
        String formattedMessage = MessageFormatter.basicArrayFormat((String)msg, (Object[])arguments);
        this.logger.log(this.getFullyQualifiedCallerName(), (Priority)log4jLevel, (Object)formattedMessage, throwable);
    }

    public void log(org.slf4j.event.LoggingEvent event) {
        Level log4jLevel = this.toLog4jLevel(event.getLevel().toInt());
        if (!this.logger.isEnabledFor((Priority)log4jLevel)) {
            return;
        }
        LoggingEvent log4jevent = this.toLog4jEvent(event, log4jLevel);
        this.logger.callAppenders(log4jevent);
    }

    private LoggingEvent toLog4jEvent(org.slf4j.event.LoggingEvent event, Level log4jLevel) {
        String formattedMessage = MessageFormatter.basicArrayFormat((String)event.getMessage(), (Object[])event.getArgumentArray());
        LocationInfo locationInfo = new LocationInfo("NA/SubstituteLogger", "NA/SubstituteLogger", "NA/SubstituteLogger", "0");
        ThrowableInformation ti = null;
        Throwable t = event.getThrowable();
        if (t != null) {
            ti = new ThrowableInformation(t);
        }
        LoggingEvent log4jEvent = new LoggingEvent(FQCN, (Category)this.logger, event.getTimeStamp(), log4jLevel, (Object)formattedMessage, event.getThreadName(), ti, null, locationInfo, null);
        return log4jEvent;
    }

    private Level toLog4jLevel(int slf4jLevelInt) {
        Level log4jLevel;
        switch (slf4jLevelInt) {
            case 0: {
                log4jLevel = this.traceCapable ? Level.TRACE : Level.DEBUG;
                break;
            }
            case 10: {
                log4jLevel = Level.DEBUG;
                break;
            }
            case 20: {
                log4jLevel = Level.INFO;
                break;
            }
            case 30: {
                log4jLevel = Level.WARN;
                break;
            }
            case 40: {
                log4jLevel = Level.ERROR;
                break;
            }
            default: {
                throw new IllegalStateException("Level number " + slf4jLevelInt + " is not recognized.");
            }
        }
        return log4jLevel;
    }

    protected String getFullyQualifiedCallerName() {
        return FQCN;
    }
}

