/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfparser.BaseParser;
import org.apache.pdfbox.pdfparser.InputStreamSource;
import org.apache.pdfbox.pdfparser.XrefTrailerResolver;

public class PDFXrefStreamParser
extends BaseParser {
    private final XrefTrailerResolver xrefTrailerResolver;
    private final int[] w = new int[3];
    private final List<Long> objNums = new ArrayList<Long>();

    public PDFXrefStreamParser(COSStream stream, COSDocument document, XrefTrailerResolver resolver) throws IOException {
        super(new InputStreamSource(stream.createInputStream()));
        this.document = document;
        this.xrefTrailerResolver = resolver;
        try {
            this.initParserValues(stream);
        }
        catch (IOException exception) {
            this.close();
        }
    }

    private void initParserValues(COSStream stream) throws IOException {
        COSArray wArray = stream.getCOSArray(COSName.W);
        if (wArray == null) {
            throw new IOException("/W array is missing in Xref stream");
        }
        for (int i = 0; i < 3; ++i) {
            this.w[i] = wArray.getInt(i, 0);
        }
        COSArray indexArray = stream.getCOSArray(COSName.INDEX);
        if (indexArray == null) {
            indexArray = new COSArray();
            indexArray.add(COSInteger.ZERO);
            indexArray.add(COSInteger.get(stream.getInt(COSName.SIZE, 0)));
        }
        Iterator<COSBase> indexIter = indexArray.iterator();
        while (indexIter.hasNext()) {
            COSBase base = indexIter.next();
            if (!(base instanceof COSInteger)) {
                throw new IOException("Xref stream must have integer in /Index array");
            }
            long objID = ((COSInteger)base).longValue();
            if (!indexIter.hasNext()) break;
            base = indexIter.next();
            if (!(base instanceof COSInteger)) {
                throw new IOException("Xref stream must have integer in /Index array");
            }
            int size = ((COSInteger)base).intValue();
            for (int i = 0; i < size; ++i) {
                this.objNums.add(objID + (long)i);
            }
        }
    }

    private void close() throws IOException {
        if (this.seqSource != null) {
            this.seqSource.close();
        }
        this.document = null;
        this.objNums.clear();
    }

    public void parse() throws IOException {
        Iterator<Long> objIter = this.objNums.iterator();
        byte[] currLine = new byte[this.w[0] + this.w[1] + this.w[2]];
        while (!this.seqSource.isEOF() && objIter.hasNext()) {
            int type;
            this.seqSource.read(currLine);
            Long objID = objIter.next();
            int n = type = this.w[0] == 0 ? 1 : (int)this.parseValue(currLine, 0, this.w[0]);
            if (type == 0) continue;
            long offset = this.parseValue(currLine, this.w[0], this.w[1]);
            int genNum = type == 1 ? (int)this.parseValue(currLine, this.w[0] + this.w[1], this.w[2]) : 0;
            COSObjectKey objKey = new COSObjectKey(objID, genNum);
            if (type == 1) {
                this.xrefTrailerResolver.setXRef(objKey, offset);
                continue;
            }
            this.xrefTrailerResolver.setXRef(objKey, -offset);
        }
        this.close();
    }

    private long parseValue(byte[] data, int start, int length) {
        long value = 0L;
        for (int i = 0; i < length; ++i) {
            value += ((long)data[i + start] & 0xFFL) << (length - i - 1) * 8;
        }
        return value;
    }
}

