/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.multipart;

import com.opensymphony.xwork2.LocaleProviderFactory;
import com.opensymphony.xwork2.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.dispatcher.LocalizedMessage;
import org.apache.struts2.dispatcher.multipart.MultiPartRequest;

public abstract class AbstractMultiPartRequest
implements MultiPartRequest {
    private static final Logger LOG = LogManager.getLogger(AbstractMultiPartRequest.class);
    public static final int BUFFER_SIZE = 10240;
    protected List<LocalizedMessage> errors = new ArrayList<LocalizedMessage>();
    protected long maxSize;
    protected boolean maxSizeProvided;
    protected int bufferSize = 10240;
    protected String defaultEncoding;
    protected Locale defaultLocale = Locale.ENGLISH;

    @Inject(value="struts.multipart.bufferSize", required=false)
    public void setBufferSize(String bufferSize) {
        this.bufferSize = Integer.parseInt(bufferSize);
    }

    @Inject(value="struts.i18n.encoding")
    public void setDefaultEncoding(String enc) {
        this.defaultEncoding = enc;
    }

    @Inject(value="struts.multipart.maxSize")
    public void setMaxSize(String maxSize) {
        this.maxSizeProvided = true;
        this.maxSize = Long.parseLong(maxSize);
    }

    @Inject
    public void setLocaleProviderFactory(LocaleProviderFactory localeProviderFactory) {
        this.defaultLocale = localeProviderFactory.createLocaleProvider().getLocale();
    }

    protected void setLocale(HttpServletRequest request) {
        if (this.defaultLocale == null) {
            this.defaultLocale = request.getLocale();
        }
    }

    protected LocalizedMessage buildErrorMessage(Throwable e, Object[] args) {
        String errorKey = "struts.messages.upload.error." + e.getClass().getSimpleName();
        LOG.debug("Preparing error message for key: [{}]", (Object)errorKey);
        return new LocalizedMessage(this.getClass(), errorKey, e.getMessage(), args);
    }

    @Override
    public List<LocalizedMessage> getErrors() {
        return this.errors;
    }

    protected String getCanonicalName(String originalFileName) {
        String fileName = originalFileName;
        int forwardSlash = fileName.lastIndexOf(47);
        int backwardSlash = fileName.lastIndexOf(92);
        fileName = forwardSlash != -1 && forwardSlash > backwardSlash ? fileName.substring(forwardSlash + 1, fileName.length()) : fileName.substring(backwardSlash + 1, fileName.length());
        return fileName;
    }
}

