/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.lifecycle.Phase;
import com.sun.faces.util.Util;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;

public class ProcessValidationsPhase
extends Phase {
    private static Logger logger = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.lifecycle");

    public PhaseId getId() {
        return PhaseId.PROCESS_VALIDATIONS;
    }

    public void execute(FacesContext facesContext) throws FacesException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Entering ProcessValidationsPhase");
        }
        UIViewRoot component = facesContext.getViewRoot();
        assert (null != component);
        try {
            component.processValidators(facesContext);
        }
        catch (RuntimeException re) {
            String exceptionMessage = re.getMessage();
            if (null != exceptionMessage && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, exceptionMessage, re);
            }
            throw new FacesException(exceptionMessage, (Throwable)re);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Exiting ProcessValidationsPhase");
        }
    }
}

