/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sslplugin.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class RequestUtil {
    public static String buildQueryString(HttpServletRequest request) {
        String queryString = request.getQueryString();
        StringBuffer finalQs = new StringBuffer();
        if (queryString != null && queryString.length() != 0) {
            finalQs.append(queryString);
        } else {
            queryString = RequestUtil.getRequestParameters(request);
            if (queryString != null && queryString.length() != 0) {
                finalQs.append(queryString);
            }
        }
        return finalQs.length() == 0 ? null : finalQs.toString();
    }

    public static String getRequestParameters(HttpServletRequest aRequest) {
        return RequestUtil.createQueryStringFromMap(aRequest.getParameterMap(), "&").toString();
    }

    public static StringBuffer createQueryStringFromMap(Map m, String ampersand) {
        StringBuffer aReturn = new StringBuffer("");
        Set aEntryS = m.entrySet();
        for (Map.Entry aEntry : aEntryS) {
            Object value = aEntry.getValue();
            String[] aValues = new String[1];
            if (value == null) {
                aValues[0] = "";
            } else if (value instanceof List) {
                List aList = (List)value;
                aValues = aList.toArray(new String[aList.size()]);
            } else if (value instanceof String) {
                aValues[0] = (String)value;
            } else {
                aValues = (String[])value;
            }
            for (int i = 0; i < aValues.length; ++i) {
                RequestUtil.append(aEntry.getKey(), aValues[i], aReturn, ampersand);
            }
        }
        return aReturn;
    }

    private static StringBuffer append(Object key, Object value, StringBuffer queryString, String ampersand) {
        if (queryString.length() > 0) {
            queryString.append(ampersand);
        }
        try {
            queryString.append(URLEncoder.encode(key.toString(), "UTF-8"));
            queryString.append("=");
            queryString.append(URLEncoder.encode(value.toString(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return queryString;
    }
}

