/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.TNSAddress;

import java.util.Vector;
import oracle.net.TNSAddress.SOException;
import oracle.net.TNSAddress.SchemaObject;
import oracle.net.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public class Description
implements SchemaObject {
    public Vector children = new Vector();
    private SchemaObject child;
    private NVPair childnv;
    protected SchemaObjectFactoryInterface f = null;
    public boolean sourceRoute = false;
    public boolean loadBalance = false;
    public boolean failover = true;
    public String SDU;
    public Vector protocolStacks = new Vector();
    public String connectData;
    public String SID;
    public String server;
    public String serviceName;
    public String instanceName;
    public String handlerName;
    public String oracleHome;
    public String authTypes;
    public Vector authParams = new Vector();
    public Vector extraConnInfo = new Vector();
    public Vector extraInfo = new Vector();

    public Description(SchemaObjectFactoryInterface schemaObjectFactoryInterface) {
        this.f = schemaObjectFactoryInterface;
    }

    protected void init() {
        this.children.removeAllElements();
        this.child = null;
        this.childnv = null;
        this.sourceRoute = false;
        this.loadBalance = false;
        this.failover = true;
        this.protocolStacks.removeAllElements();
        this.SDU = null;
        this.SID = null;
        this.server = null;
        this.serviceName = null;
        this.instanceName = null;
        this.handlerName = null;
        this.oracleHome = null;
        this.authTypes = null;
        this.authParams.removeAllElements();
        this.extraConnInfo.removeAllElements();
        this.extraInfo.removeAllElements();
    }

    public void initFromNVPair(NVPair nVPair) throws SOException {
        this.init();
        int n = nVPair.getListSize();
        if (n == 0) {
            throw new SOException();
        }
        int n2 = 0;
        while (n2 < n) {
            NVPair nVPair2;
            int n3;
            this.childnv = nVPair.getListElement(n2);
            if (this.childnv.getName().equalsIgnoreCase("SOURCE_ROUTE")) {
                this.sourceRoute = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
            } else if (this.childnv.getName().equalsIgnoreCase("LOAD_BALANCE")) {
                this.loadBalance = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
            } else if (this.childnv.getName().equalsIgnoreCase("FAILOVER")) {
                this.failover = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
            } else if (this.childnv.getName().equalsIgnoreCase("PROTOCOL_STACK")) {
                this.protocolStacks.addElement(this.childnv.toString());
            } else if (this.childnv.getName().equalsIgnoreCase("ADDRESS")) {
                this.child = this.f.create(0);
                this.child.initFromNVPair(this.childnv);
                this.children.addElement(this.child);
            } else if (this.childnv.getName().equalsIgnoreCase("ADDRESS_LIST")) {
                this.child = this.f.create(1);
                this.child.initFromNVPair(this.childnv);
                this.children.addElement(this.child);
            } else if (this.childnv.getName().equalsIgnoreCase("SDU")) {
                this.SDU = this.childnv.getAtom();
            } else if (this.childnv.getName().equalsIgnoreCase("CONNECT_DATA")) {
                this.connectData = this.childnv.valueToString();
                int n4 = this.childnv.getListSize();
                if (n4 == 0) {
                    throw new SOException();
                }
                n3 = 0;
                while (n3 < n4) {
                    nVPair2 = this.childnv.getListElement(n3);
                    if (nVPair2.getName().equalsIgnoreCase("SID")) {
                        this.SID = nVPair2.getAtom();
                    } else if (nVPair2.getName().equalsIgnoreCase("SERVER")) {
                        this.server = nVPair2.getAtom();
                    } else if (nVPair2.getName().equalsIgnoreCase("SERVICE_NAME")) {
                        this.serviceName = nVPair2.getAtom();
                    } else if (nVPair2.getName().equalsIgnoreCase("INSTANCE_NAME")) {
                        this.instanceName = nVPair2.getAtom();
                    } else if (nVPair2.getName().equalsIgnoreCase("HANDLER_NAME")) {
                        this.handlerName = nVPair2.getAtom();
                    } else if (nVPair2.getName().equalsIgnoreCase("ORACLE_HOME")) {
                        this.oracleHome = nVPair2.getAtom();
                    } else {
                        String string = nVPair2.toString().trim();
                        string = string.substring(1, string.length() - 1);
                        this.extraConnInfo.addElement(string);
                    }
                    ++n3;
                }
            } else if (this.childnv.getName().equalsIgnoreCase("SECURITY")) {
                int n5 = this.childnv.getListSize();
                if (n5 == 0) {
                    throw new SOException();
                }
                n3 = 0;
                while (n3 < n5) {
                    nVPair2 = this.childnv.getListElement(n3);
                    if (nVPair2.getName().equalsIgnoreCase("AUTHENTICATION")) {
                        this.authTypes = nVPair2.toString();
                    } else {
                        this.authParams.addElement(nVPair2.toString());
                    }
                    ++n3;
                }
            } else {
                String string = this.childnv.toString().trim();
                string = string.substring(1, string.length() - 1);
                this.extraInfo.addElement(string);
            }
            ++n2;
        }
    }

    public void initFromString(String string) throws NLException, SOException {
        NVPair nVPair = new NVFactory().createNVPair(string);
        if (nVPair == null) {
            throw new NLException(100);
        }
        this.initFromNVPair(nVPair);
    }

    public int isA() {
        return 2;
    }

    public String isA_String() {
        return "DESCRIPTION";
    }

    public String toString() {
        int n;
        int n2;
        String string = new String("");
        string = String.valueOf(string) + "(DESCRIPTION=";
        if (this.protocolStacks.size() != 0) {
            n2 = 0;
            while (n2 < this.protocolStacks.size()) {
                string = String.valueOf(string) + (String)this.protocolStacks.elementAt(n2);
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < this.children.size()) {
            string = String.valueOf(string) + ((SchemaObject)this.children.elementAt(n2)).toString();
            ++n2;
        }
        if (this.sourceRoute) {
            string = String.valueOf(string) + "(SOURCE_ROUTE=yes)";
        }
        if (this.loadBalance) {
            string = String.valueOf(string) + "(LOAD_BALANCE=yes)";
        }
        if (!this.failover) {
            string = String.valueOf(string) + "(FAILOVER=false)";
        }
        if (this.SDU != null) {
            string = String.valueOf(string) + "(SDU=" + this.SDU + ")";
        }
        if (this.SID != null || this.server != null || this.serviceName != null || this.instanceName != null || this.handlerName != null || this.extraConnInfo.size() != 0 || this.oracleHome != null) {
            string = String.valueOf(string) + "(CONNECT_DATA=";
            if (this.SID != null) {
                string = String.valueOf(string) + "(SID=" + this.SID + ")";
            }
            if (this.server != null) {
                string = String.valueOf(string) + "(SERVER=" + this.server + ")";
            }
            if (this.serviceName != null) {
                string = String.valueOf(string) + "(SERVICE_NAME=" + this.serviceName + ")";
            }
            if (this.instanceName != null) {
                string = String.valueOf(string) + "(INSTANCE_NAME=" + this.instanceName + ")";
            }
            if (this.handlerName != null) {
                string = String.valueOf(string) + "(HANDLER_NAME=" + this.handlerName + ")";
            }
            if (this.oracleHome != null) {
                string = String.valueOf(string) + "(ORACLE_HOME=" + this.oracleHome + ")";
            }
            n = 0;
            while (n < this.extraConnInfo.size()) {
                string = String.valueOf(string) + "(" + (String)this.extraConnInfo.elementAt(n) + ")";
                ++n;
            }
            string = String.valueOf(string) + ")";
        }
        if (this.authTypes != null || this.authParams.size() != 0) {
            string = String.valueOf(string) + "(SECURITY=";
            if (this.authTypes != null) {
                string = String.valueOf(string) + "(AUTHENTICATION=" + this.authTypes + ")";
            }
            n = 0;
            while (n < this.authParams.size()) {
                string = String.valueOf(string) + (String)this.authParams.elementAt(n);
                ++n;
            }
            string = String.valueOf(string) + ")";
        }
        n = 0;
        while (n < this.extraInfo.size()) {
            string = String.valueOf(string) + "(" + (String)this.extraInfo.elementAt(n) + ")";
            ++n;
        }
        string = String.valueOf(string) + ")";
        return string;
    }
}

