/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sslplugin.interceptors;

import com.googlecode.sslplugin.annotation.Secured;
import com.googlecode.sslplugin.util.RequestUtil;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.lang.reflect.Method;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SSLInterceptor
extends AbstractInterceptor {
    private static Log log = LogFactory.getLog(SSLInterceptor.class);
    private String httpsPort;
    private String httpPort;
    private boolean useAnnotations = true;
    static final int HTTP_PORT = 8080;
    static final int HTTPS_PORT = 8443;
    static final String HTTP_GET = "GET";
    static final String HTTP_POST = "POST";
    static final String SCHEME_HTTP = "http";
    static final String SCHEME_HTTPS = "https";

    public SSLInterceptor() {
        log.info((Object)"Intializing SSLInterceptor");
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        ActionContext context = invocation.getInvocationContext();
        HttpServletRequest request = (HttpServletRequest)context.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        HttpServletResponse response = (HttpServletResponse)context.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        String scheme = request.getScheme().toLowerCase();
        String method = request.getMethod().toUpperCase();
        Object action = invocation.getAction();
        Method method2 = this.getActionMethod(action.getClass(), invocation.getProxy().getMethod());
        if (!this.isUseAnnotations() || action.getClass().isAnnotationPresent(Secured.class) || method2.isAnnotationPresent(Secured.class)) {
            if ((HTTP_GET.equals(method) || HTTP_POST.equals(method)) && SCHEME_HTTP.equals(scheme)) {
                int httpsPort = this.getHttpsPort() == null ? 8443 : Integer.parseInt(this.getHttpsPort());
                URI uri = new URI(SCHEME_HTTPS, null, request.getServerName(), httpsPort, response.encodeRedirectURL(request.getRequestURI()), RequestUtil.buildQueryString(request), null);
                log.info((Object)("Going to SSL mode, redirecting to " + uri.toString()));
                response.sendRedirect(uri.toString());
                return null;
            }
        } else if ((HTTP_GET.equals(method) || HTTP_POST.equals(method)) && SCHEME_HTTPS.equals(scheme)) {
            int httpPort = this.getHttpPort() == null ? 8080 : Integer.parseInt(this.getHttpPort());
            URI uri = new URI(SCHEME_HTTP, null, request.getServerName(), httpPort, response.encodeRedirectURL(request.getRequestURI()), RequestUtil.buildQueryString(request), null);
            log.info((Object)("Going to non-SSL mode, redirecting to " + uri.toString()));
            response.sendRedirect(uri.toString());
            return null;
        }
        return invocation.invoke();
    }

    protected Method getActionMethod(Class actionClass, String methodName) throws NoSuchMethodException {
        Method method;
        try {
            method = actionClass.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                String altMethodName = "do" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
                method = actionClass.getMethod(altMethodName, new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                throw e;
            }
        }
        return method;
    }

    public String getHttpsPort() {
        return this.httpsPort;
    }

    @Inject(value="struts2.sslplugin.httpsPort", required=false)
    public void setHttpsPort(String httpsPort) {
        this.httpsPort = httpsPort;
    }

    public String getHttpPort() {
        return this.httpPort;
    }

    @Inject(value="struts2.sslplugin.httpPort", required=false)
    public void setHttpPort(String httpPort) {
        this.httpPort = httpPort;
    }

    public boolean isUseAnnotations() {
        return this.useAnnotations;
    }

    public void setUseAnnotations(boolean useAnnotations) {
        this.useAnnotations = useAnnotations;
    }

    @Inject(value="struts2.sslplugin.annotations", required=false)
    public void setAnnotations(String annotations) {
        if (annotations == null) {
            annotations = "true";
        }
        this.useAnnotations = new Boolean(annotations);
    }
}

